function P83_ii
% Problem 8.3 :	Double-Well Potential System
% i. Initial Condition Sensitivity for Large External Force

% Define some parameters
x01=[-0.05 0];          % First initial condition
x02=[-0.05 -0.05];      % Second initial condition
F=0.40;                 % Amplitude of external force
% Solve equation of motion with the first initial conditions
[T1,X1]=ode45(@(t,x)DoubleWell(t,x,F),[0,100],x01);
% Solve equation of motion with the second initial conditions
[T2,X2]=ode45(@(t,x)DoubleWell(t,x,F),[0,100],x02);
% Plot and compare above two time response
plot(T1,X1(:,1),'r-',T2,X2(:,1),'b--');
grid on; axis tight;
set(gca,'FontSize',14);
xlabel('\bfTime (second)');
ylabel('\bfLateral Trajectory of Particle (a.u.)');
title('\bfInitial Condition Sensitivity for Small External Force F=0.40');
legend('\bfx_0=-0.05&v_0=0','\bfx_0=-0.05&v_0=-0.05');
end

function dx=DoubleWell(t,x,F)
% Describe euation of motion
% in the double-well potetial system
dx(1,1)=x(2);
dx(2,1)=F*cos(t)-0.25*x(2)+x(1)-x(1)^3;
end